IF EXISTS (SELECT
						 *
					 FROM
						 SYS.VIEWS
					 WHERE
						OBJECT_ID = OBJECT_ID(N'[DBO].[V_PDV_VD_TRIBUTOS_TAXAS]'))
	DROP VIEW [DBO].[V_PDV_VD_TRIBUTOS_TAXAS]

GO  -- SELECT * FROM V_PDV_VD_TRIBUTOS_TAXAS WHERE CD_FILIAL = 36 AND DT_VD = '20170810' AND CD_CX = 4 

CREATE VIEW V_PDV_VD_TRIBUTOS_TAXAS
WITH ENCRYPTION
AS
	-- versao 2928 ok   
	SELECT
		CD_EMP
		,CD_FILIAL
		,CD_CX
		,DT_VD
		,CONVERT(MONEY, ROUND(SUM(VLR_TOT_BASE), 2)) AS VLR_TOT_BASE
		,CONVERT(MONEY, TX_ICMS_IT)                  AS TX_ICMS_IT
		,CONVERT(MONEY, SUM(VLR_IMPOSTO) )  AS VLR_IMPOSTO
		,TIPO_IMPOSTO
	FROM
		(
		
		SELECT
			 PDV_VD.CD_EMP
			 ,PDV_VD.CD_FILIAL
			 ,PDV_VD.CD_CX
			 ,PDV_VD.DT_VD
			 ,CASE WHEN PRC_FILIAL.REGIME_TRIBUTARIO IN (1,2) AND PDV_VD_IT.CD_TRIB_FC='500' THEN
				0
			 ELSE
				CASE WHEN ISNULL(TIPO_IMPOSTO, 0) = 1 THEN 
					( PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT )
				ELSE ( PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT )
				END                     
			END AS VLR_TOT_BASE
			 
			,CASE WHEN PRC_FILIAL.REGIME_TRIBUTARIO IN (1,2) AND PDV_VD_IT.CD_TRIB_FC='500' THEN
				0
			 ELSE 
				CASE WHEN RIGHT (PDV_VD_IT.CD_TRIB_FC, 2) in  ('00','02') THEN
					PDV_VD_IT.TX_ICMS_IT
				WHEN  RIGHT (PDV_VD_IT.CD_TRIB_FC, 2) = '20' THEN
					ROUND((TX_ICMS_IT * TX_RED_IT) / 100.0000 ,2)	
				ELSE
					0   
				END 
			END TX_ICMS_IT

			 ,CASE WHEN PRC_FILIAL.REGIME_TRIBUTARIO IN (1,2) AND PDV_VD_IT.CD_TRIB_FC='500' THEN
				0
			 ELSE
				 CASE WHEN ISNULL(TX_RED_IT,0) > 0 AND RIGHT (PDV_VD_IT.CD_TRIB_FC, 2) = '20' THEN
					((PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT ) * (TX_ICMS_IT * TX_RED_IT) / 100.0000 ) / 100.0000
				 ELSE
					( PDV_VD_IT.TOT_IT - VLR_DESC_TOT_RAT ) * ( PDV_VD_IT.TX_ICMS_IT / 100.0000 ) 
				 END 
			END AS VLR_IMPOSTO

			 ,ISNULL(TIPO_IMPOSTO, 0) AS TIPO_IMPOSTO

		 FROM
			 PDV_VD_IT
			 INNER JOIN PDV_VD ON
				 PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
				 PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
				 PDV_VD.CD_VD = PDV_VD_IT.CD_VD
				INNER JOIN PRC_FILIAL ON
				PDV_VD.CD_EMP = PRC_FILIAL.CD_EMP AND
				PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
		 WHERE
			PDV_VD.ST_VD         = 0 AND
			PDV_VD_IT.ST_IT      = 1
			AND RIGHT (PDV_VD_IT.CD_TRIB_FC, 2) in  ('00','02','20') 
			AND ISNULL(PDV_VD.TIPO ,0) = 0 
			--AND PDV_VD_IT.CD_FILIAL =36
			--AND PDV_VD_IT.DT_VD ='20170810'
			--AND PDV_VD.CD_CX = 4
			--and 
			
			) TEMP
	GROUP  BY
		CD_EMP
		,CD_FILIAL
		,CD_CX
		,DT_VD
		,TX_ICMS_IT
		,TIPO_IMPOSTO 
